/*
 * main.h
 *
 *  Created on: Feb 27, 2013
 *      Author: a0273379
 */

#ifndef MAIN_H_
#define MAIN_H_

#define MOD_TRF_ON  P2OUT |= BIT0; //***
#define MOD_TRF_OFF P2OUT &= ~BIT0; //***
#define TRF_CARRIER_ON  MOD_TRF_OFF
#define TRF_CARRIER_OFF MOD_TRF_ON
#define MOD_TRF_DIR_Out P2DIR |= BIT0;  //***

#define TRFWrite    P4OUT       //port4 is connected to the
#define TRFRead     P4IN        //TRF796x IO port.
#define TRFDirIN    P4DIR = 0x00
#define TRFDirOUT   P4DIR = 0xFF
#define TRFSerial   P4DIR = 0x9F  //Note sure !!!! - Harsha
#define TRFFunc     P4SEL = 0x00

#define OOKdirIN    P2DIR &= ~BIT2;
#define OOKdirOUT   P2DIR |= BIT2
#define OOKoff      P2OUT &= ~BIT2
#define OOKon       P2OUT |= BIT2

#define SETUP       3
#define SET         2
#define TRIGGERED   1

#define THRESHOLD_OFFSET        3       // amount change from idle (calibrated) value sniff value that will trigger card detected, so a setting of 3 will need idle state sniffing value + 3 to trigger a read
#define CALIBRATE_CYCLES        12      // number of cycles to be used for calibration on power up, for fast processing keep power of two, (this x wakeup period) = the calibrating time
#define SAMPLES_TO_DISCARD      4       // number of samples to skip when calibrating, the first few samples may contain uncertain numbers so these are discarded

#define TRF_CLOCK_SOURCE        0
#define DCO_CLOCK_SOURCE        1

#define SMCLK_CLOCK             TBSSEL1
#define ACLK_CLOCK              TBSSEL0

#define USE_AUTOMATIC_CALIBRATION

#define SYSTEM_SLEEP_TIME			3996		//Number of cycles in 12kHz for system to sleep

//#define SENSE_PIN_PULL_DOWN				P2DIR &= ~BIT4;\
										P2OUT &= ~BIT4;\
										P2REN |= BIT4;

void DirectMode(void);
void InitComparator(void);
u16_t ComparatorSlopeTime(void);
void ReInitForStandardOp(void);
void InitForCardSniff();
void SetWakeupTimer(u16_t num_cycles, u16_t clock_source);
void StopWakeupTimer ();
void SetupSleepState ();
void SetupSleepState2 ();
void SetupWakeState ();
void SetupWakeState2 ();
void SniffInitialSettings(void);
u08_t Initial_Calibration (u16_t time);
void InitTimerA(void);

#endif /* MAIN_H_ */
